package it.eng.eremita.graphql.types;

import java.util.Date;

import it.eng.eremita.jpa.entity.Utente;

public interface Trackable<X,Y> extends Identifiable<Y> {
	
	public X getUtenteCreazione();
	public void setUtenteCreazione(X utente);
	public X getUtenteModifica();
	public void setUtenteModifica(X utente);
	
	public Date getDataCreazione();
	public void setDataCreazione(Date d);
	public Date getDataModifica();
	public void setDataModifica(Date d);

	
	default public boolean ownedBy(Utente u) {
		return (getUtenteCreazione()!=null && getUtenteCreazione().equals(u));
	}
}
